
/*******************************************************************************/
/*  
	This script produces Figure 1 	
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/


/*----------------------------------------------------*/
	/* [>   Correlation 2 digit    <] */ 
/*----------------------------------------------------*/

use "../Data/2_digit_pp_wfh_onet.dta", clear
label values occ_2digit occ_2_label
format pp low_wfh %2.1f

gen orientleft = inlist(occ_2digit, 1, 16, 30, 36, 43, 77, 90) // for label position

graph drop _all
twoway ///
	(scatter low_wfh pp if occ_1digit == 1 & !orientleft, mc(blue)  ms(X) msize(vlarge) mlabel(occ_2digit) mlabcolor(blue)  mlabsize(med) mlabposition("3")) ///
	(scatter low_wfh pp if occ_1digit == 1 & orientleft , mc(blue)  ms(X) msize(vlarge) mlabel(occ_2digit) mlabcolor(blue)  mlabsize(med) mlabposition("9")) ///
	(scatter low_wfh pp if occ_1digit == 2 & !orientleft, mc(red)   ms(D) msize(med)     mlabel(occ_2digit) mlabcolor(red)   mlabsize(med) mlabposition("3")) ///
	(scatter low_wfh pp if occ_1digit == 2 & orientleft , mc(red)   ms(D) msize(med)     mlabel(occ_2digit) mlabcolor(red)   mlabsize(med) mlabposition("9")) ///
 	(lfitci  low_wfh pp [aw=tot_emp] , ciplot(rline) alcolor(gray) alwidth(medthick) alpattern(_) clcolor(gray) clwidth(medthick)) ///
	, ytitle("Low work-from-home >>") xtitle("High physical-proximity >>") ///
	yline(0.167, lc(red) lp(dash) lw(medthick)) xline(0.584, lc(blue) lp(dash) lw(medthick)) ///
	legend(pos("10")  cols(1) order(1 "Professional, management, tech." 3 "Services")) ///
	title("(i) Professional, management, technology; (ii) Services") ///
	xsize(2) ysize(1) nodraw name(A1) ///
    xscale(range(0 1.01)) xlabel(0.0(0.2)1.0) ///
    yscale(range(0 1.02) noex) ylabel(0(0.2)1.0)  
twoway ///
	(scatter low_wfh pp if occ_1digit == 3 & !orientleft, mc(green) ms(T) msize(large)   mlabel(occ_2digit) mlabcolor(green) mlabsize(med)) ///
	(scatter low_wfh pp if occ_1digit == 4 & !orientleft, mc(black) ms(O) msize(large)   mlabel(occ_2digit) mlabcolor(black) mlabsize(med) mlabposition("3")) ///
	(scatter low_wfh pp if occ_1digit == 4 & orientleft , mc(black) ms(O) msize(large)   mlabel(occ_2digit) mlabcolor(black) mlabsize(med) mlabposition("9")) ///
 	(lfitci  low_wfh pp [aw=tot_emp] , ciplot(rline) alcolor(gray) alwidth(medthick) alpattern(_) clcolor(gray) clwidth(medthick)) ///
	, ytitle("Low work-from-home >>") xtitle("High physical-proximity >>") ///
	yline(0.167, lc(red) lp(dash) lw(medthick)) xline(0.584, lc(blue) lp(dash) lw(medthick)) ///
	legend(pos("10")  cols(1) order(1 "Clerical, sales" 2 "Production, operators")) ///
	title("(iii) Clerical, sales; (iv) Production, operators ") ///
	xsize(2) ysize(1) nodraw name(A2) ///
    xscale(range(0 1.01)) xlabel(0.0(0.2)1.0)  yscale(range(0 1.02)  noex) ylabel(0(0.2)1.0) 


graph combine A1 A2
graph export "../Figures/fig1.eps", replace
